import { WebComponent } from '../component.js';

class XCountry extends WebComponent {
    static observed = ['value', 'postcode'];
    default = HTMLInputElement;
    element = HTMLInputElement;
    countries = [];

    get value() {
        return this.getAttribute('value');
    }

    set value(value) {
        if (this.getAttribute('value') != value) {
            this.setAttribute('value', value);
        }

        if (this.element.value != value) {
            this.element.value = value;
        }
    }

    set postcode(value) {
        if (this.hasAttribute('target')) {
            this.setAttribute('postcode', value);

            let target = document.getElementById(this.getAttribute('target'));

            if (value == 1) {
                target.setAttribute('required', '');
            } else {
                target.removeAttribute('required');
            }
        }
    }

    get postcode() {
        return this.getAttribute('postcode');
    }

    event = {
        connected: async () => {
            this.default = this.innerHTML;

            let html = '<select name="' + this.getAttribute('name') + '" id="' + this.getAttribute('input-id') + '" class="form-select"';

            if (this.hasAttribute('required')) {
                html += ' required';
            }

            if (this.hasAttribute('disabled')) {
                html += ' disabled';
            }

            html += '>' + this.default + '</select>';

            this.innerHTML = html;

            this.addEventListener('[value]', this.event.changeValue);

            this.element = this.querySelector('select');

            this.addEventListener('[value]', this.event.changeValue);

            let response = this.storage.fetch('localisation/country');

            response.then(this.event.onloaded);
            response.then(this.event.option);
            response.then(this.event.postcode);
        },
        onloaded: (countries) => {
            this.countries = countries;
        },
        option: () => {
            let html = this.default;

            for (let i in this.countries) {
                html += '<option value="' + this.countries[i].country_id + '"';

                if (this.countries[i].country_id == this.value) {
                    html += ' selected';
                }

                html += '>' + this.countries[i].name + '</option>';
            }

            this.element.innerHTML = html;
        },
        postcode: () => {
            if (this.countries[this.value] !== undefined) {
                this.postcode = this.countries[this.value].postcode_required;
            } else {
                this.postcode = 0;
            }
        },
        onchange: (e) => {
            this.value = e.target.value;
        },
        changeValue: (e) => {
            this.value = e.detail.value_new;
        }
    };
}

customElements.define('x-country', XCountry);